package com.biz.crm.nebular.mdm.region;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "行政区域返回")
@CrmColumnResolve
public class MdmRegionRespVo extends CrmExtTenVo {
    @ApiModelProperty("区域编码")
    @SaturnColumn(description = "区域编码")
    private String regionCode;

    @ApiModelProperty("上级编码")
    @SaturnColumn(description = "上级编码")
    private String parentCode;

    @ApiModelProperty("上级区域名称")
    private String parentName;

    @ApiModelProperty("名称")
    @SaturnColumn(description = "名称")
    private String regionName;

    @ApiModelProperty("层级 0 1 2 省市区县")
    @SaturnColumn(description = "层级 0 1 2 省市区县")
    private String regionLevel;

    @ApiModelProperty("区域层级名称")
    @CrmDict(typeCode = DictConstant.REGION_LEVEL,dictCodeField = "regionLevel")
    private String regionLevelName;

    @ApiModelProperty("邮编")
    @SaturnColumn(description = "邮编")
    private String email;

    @ApiModelProperty("经度")
    @SaturnColumn(description = "经度")
    private String longitude;

    @ApiModelProperty("纬度")
    @SaturnColumn(description = "纬度")
    private String latitude;

    @ApiModelProperty("是否有子节点")
    private Boolean hasChild;

}