package com.biz.crm.nebular.sfa.calculateSalary.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 计算薪资年 返回vo
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "计算薪资年 ")
@SaturnEntity(name = "SfaCalculateSalaryYearRespVo", description = "计算薪资年 ")
public class SfaCalculateSalaryYearRespVo extends CrmExtTenVo {
    @ApiModelProperty("年份")
    @SaturnColumn(description = "年份")
    private String year;

    @ApiModelProperty("法定节假日天数")
    @SaturnColumn(description = "法定节假日天数")
    private String holidayDays;

    @ApiModelProperty("计算薪资天数")
    @SaturnColumn(description = "计算薪资天数")
    private String salaryDays;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    @SaturnColumn(description = "真实姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("计算薪资日期")
    private List<SfaSalaryDateRespVo> salaryDateRespVoList;

}