package com.biz.crm.nebular.tpm.feebudget.req;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm 费用预算控制维度操作类型枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum FeeBudgetControlOperateTypeEnum {
    /**
     * 费用预算新增
     */
    NEW("new"),
    /**
     * 费用预算编辑
     */
    UPDATE("update"),
    /**
     * 费用预算删除
     */
    DELETE("delete"),
    /**
     * 启用
     */
    ENABLE("enable"),
    /**
     * 禁用
     */
    DISABLE("disable"),
    /**
     * 调出
     */
    ADJUST_OUT("adjust_out"),
    /**
     * 调入
     */
    ADJUST_IN("adjust_in"),
    /**
     * 变更
     */
    CHANGE("change"),
    /**
     * 使用
     */
    USE("use"),
    /**
     * 退回
     */
    RETURN("return"),
    ;

    FeeBudgetControlOperateTypeEnum(String code) {
        this.code = code;
    }

    private String code;

    public String getCode() {
        return code;
    }


}
