package com.biz.crm.nebular.dms.repfeepool;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * api接口操作（扣减、冲销、冻结、解冻）商品折扣费用池，返回结果
 * @Author: chenrong
 * @Date: 2021/1/27 14:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RepFeePoolAdjustVo implements Serializable {

  private static final long serialVersionUID = -377171648930910994L;

  /**
   * 扣减是否成功，key:商品编码，value:true/false
   */
  @ApiModelProperty(value = "扣减是否成功，key:商品编码，value:true/false")
  private Map<String, Boolean> boolResult;
  /**
   * 操作成功数量，key:商品编码，value:数量
   */
  @ApiModelProperty(value = "操作成功数量，key:商品编码，value:数量")
  private Map<String, BigDecimal> countResult;
  /**
   * 操作成功成本金额，key:商品编码，value:成本金额
   */
  @ApiModelProperty(value = "操作成功成本金额，key:商品编码，value:成本金额")
  private Map<String, BigDecimal> costFeeResult;
  /**
   * 操作成功销售金额，key:商品编码，value:销售金额
   */
  @ApiModelProperty(value = "操作成功销售金额，key:商品编码，value:销售金额")
  private Map<String, BigDecimal> saleFeeResult;
  /**
   * 操作成功计算金额，key:商品编码，value:计算金额
   */
  @ApiModelProperty(value = "操作成功计算金额，key:商品编码，value:计算金额")
  private Map<String, BigDecimal> feeResult;
}
