package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池冻结明细
 * @Author: chenrong
 * @Date: 2020/12/17 11:26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("货补费用池冻结明细")
public class RepFeePoolFrozenItemVo extends CrmExtVo {

  private static final long serialVersionUID = -2357929852247348386L;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
  /**
   * 货补费用池编码
   */
  @ApiModelProperty(value = "货补费用池明细编码")
  private String repFeePoolItemCode;
  /**
   * 冻结数量
   */
  @ApiModelProperty(value = "冻结数量")
  private BigDecimal frozenCount = BigDecimal.ZERO;
  /**
   * 已解冻数量
   */
  @ApiModelProperty(value = "已解冻数量")
  private BigDecimal unfrozenCount = BigDecimal.ZERO;
  /**
   * 剩余冻结数量
   */
  @ApiModelProperty(value = "剩余冻结数量")
  private BigDecimal remainFrozenCount = BigDecimal.ZERO;
  /**
   * 冻结金额
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal frozenFee = BigDecimal.ZERO;
  /**
   * 已解冻金额
   */
  @ApiModelProperty(value = "已解冻金额")
  private BigDecimal unfrozenFee = BigDecimal.ZERO;
  /**
   * 剩余冻结金额
   */
  @ApiModelProperty(value = "剩余冻结金额")
  private BigDecimal remainFrozenFee = BigDecimal.ZERO;
  /**
   * 冻结原因
   */
  @ApiModelProperty(value = "冻结原因")
  private String frozenReason;
  /**
   * 附件列表
   */
  @ApiModelProperty(value = "附件列表")
  private List<RepFeePoolFrozenFileVo> files;
  /**
   * 开始日期
   */
  @ApiModelProperty(value = "开始日期")
  private String startDate;
  /**
   * 结束日期
   */
  @ApiModelProperty(value = "结束日期")
  private String endDate;

  /**
   * 冗余字段：货补费用池明细对象
   */
  @ApiModelProperty(value = "冗余字段：货补费用池明细对象")
  private RepFeePoolItemVo repFeePoolItemVo;

  /**
   * bpm编码
   */
  @ApiModelProperty(value = "bpm编码")
  private String bpmCode;

  /**
   * 来源编码
   */
  @ApiModelProperty(value = "来源编码")
  private String resourceCode;

}
