package com.biz.crm.nebular.dms.salegoal;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:销售目标
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "销售目标主信息的vo（新）")
public class SaleGoalVo extends CrmExtTenVo {


  @ApiModelProperty(value = "客户编码")
  @SaturnColumn(description = "客户编码")
  private String cusCode;

  @ApiModelProperty(value = "客户名称")
  @SaturnColumn(description = "客户名称")
  private String cusName;

  @ApiModelProperty(value = "客户所属组织编码")
  @SaturnColumn(description = "客户所属组织编码")
  private String cusOrgCode;

  @ApiModelProperty(value = "客户所属组织名称")
  @SaturnColumn(description = "客户所属组织名称")
  private String cusOrgName;

  @ApiModelProperty(value = "客户所属渠道编码")
  @SaturnColumn(description = "客户所属渠道编码")
  private String cusChannelCode;

  @ApiModelProperty(value = "客户所属渠道名称")
  @SaturnColumn(description = "客户所属渠道名称")
  private String cusChannelName;

  @ApiModelProperty(value = "销售区域编码")
  @SaturnColumn(description = "销售区域编码")
  private String salesAreaCode;

  @ApiModelProperty(value = "销售区域名称")
  @SaturnColumn(description = "销售区域名称")
  private String salesAreaName;

  @ApiModelProperty(value = "销量目标类型")
  @SaturnColumn(description = "销量目标类型")
  private Integer type;

  @ApiModelProperty(value = "销量目标类型")
  @SaturnColumn(description = "销量目标类型")
  @CrmDict(typeCode = "salesTarget_type", dictCodeField = "type")
  private String typeName;

  @ApiModelProperty(value = "销量目标名称")
  @SaturnColumn(description = "销量目标名称")
  private String name;

  @ApiModelProperty(value = "目标年份")
  @SaturnColumn(description = "目标年份")
  private Integer targetYear;

  @ApiModelProperty(value = "目标年份总量")
  @SaturnColumn(description = "目标年份总量")
  private BigDecimal targetNum;

  /***/
  @ApiModelProperty(value = "目标年份总量字符串表现(不带小数点)")
  @SaturnColumn(description = "目标年份总量字符串表现(不带小数点)")
  private String targetNumStr;

  @ApiModelProperty(value = "商品编码(类型是单品销售目标 该字段不能空)")
  @SaturnColumn(description = "商品编码(类型是单品销售目标 该字段不能空)")
  private String goodsCode;

  @ApiModelProperty(value = "商品名称(类型是单品销售目标 该字段不能空)")
  @SaturnColumn(description = "商品名称(类型是单品销售目标 该字段不能空)")
  private String goodsName;

  @ApiModelProperty(value = "商品规格(类型是单品销售目标 该字段不能空)")
  @SaturnColumn(description = "商品规格(类型是单品销售目标 该字段不能空)")
  private String productSpec;

  @ApiModelProperty(value = "产品层级code(类型是非常规 该字段不能空)")
  @SaturnColumn(description = "产品层级code(类型是非常规 该字段不能空)")
  private String productLevelCode;

  @ApiModelProperty(value = "产品层级名称(类型是非常规 该字段不能空)")
  @SaturnColumn(description = "产品层级名称(类型是非常规 该字段不能空)")
  private String productLevelName;

  /***/
  @ApiModelProperty(value = "月度信息")
  @SaturnColumn(description = "月度信息")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
  private SaleGoalItemVo saleGoalItemVo;

  /**
   * 对象维度，用户、组织、终端
   */
  @ApiModelProperty(value = "对象维度，用户、组织、终端")
  private Integer objectType;

  /**
   * 任务类型，年目标、季度目标、月度目标
   */
  @ApiModelProperty(value = "任务类型，年目标、季度目标、月度目标")
  private Integer taskType;

  /**
   * 组织编码（对象维度为组织时，选择）
   */
  @ApiModelProperty(value = "组织编码（对象维度为组织时，选择）")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty(value = "组织名称")
  private String orgName;

  /**
   * 终端编码（对象维度为终端时选择）
   */
  @ApiModelProperty(value = "终端编码（对象维度为终端时选择）")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty(value = "终端名称")
  private String terminalName;

  /**
   * 合同编码
   */
  @ApiModelProperty(value = "合同编码")
  private String contractCode;

  /**
   * 唯一值，去重时查询用 (类型是单品：产品code + 目标年份 ；类型是层级：产品层级code + 目标年份;类型是常规： 目标年份)
   */
  @ApiModelProperty(value = "唯一值")
  private String onlyKey;
}
