package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池明细冻结请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDetailFreezeReqVo", description = "费用池明细冻结请求VO")
public class FeePoolDetailFreezeReqVo {

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("冻结/解冻金额")
    private BigDecimal amount;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;
}