package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 折扣费用池添加期初请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountInitAccountReqVo", description = "折扣费用池添加期初请求VO")
public class FeePoolDiscountInitAccountReqVo extends CrmExtTenVo {

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("折扣费用池类型")
    private String discountType;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;

}