package com.biz.crm.nebular.job.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: MdmScheduleJobLogReqVo
 * @Description: 定时任务执行日志入参Vo
 * @Author: Xiao
 * @Date: 2020/09/27
 **/
@Data
@ApiModel(value = "QrtzScheduleJobLogReqVo", description = "定时任务执行日志入参")
@SaturnEntity(name = "QrtzScheduleJobLogReqVo", description = "定时任务执行日志入参")
public class QrtzScheduleJobLogReqVo extends PageVo {

    /**
     * 任务名称
     */
    @ApiModelProperty("任务名称")
    @SaturnColumn(description = "任务名称")
    private String jobName;
    /**
     * 任务分组
     */
    @ApiModelProperty("任务分组")
    @SaturnColumn(description = "任务分组")
    private String jobGroup;

    /**
     * 指定执行类
     */
    @ApiModelProperty("指定执行类")
    @SaturnColumn(description = "指定执行类")
    private String jobClass;

    /**
     * 开始运行时间
     */
    @ApiModelProperty("开始运行时间")
    @SaturnColumn(description = "开始运行时间")
    private String runBeginTime;
    /**
     * 结束运行时间
     */
    @ApiModelProperty("结束运行时间")
    @SaturnColumn(description = "结束运行时间")
    private String runEndTime;
    /**
     * 运行结果
     */
    @ApiModelProperty("运行结果")
    @SaturnColumn(description = "运行结果")
    private String runStatus;
    /**
     * 运行日志
     */
    @ApiModelProperty("运行日志")
    @SaturnColumn(description = "运行日志")
    private String logContent;
    /**
     * 创建时间
     */
    @ApiModelProperty("记录时间起始")
    @SaturnColumn(description = "记录时间起始")
    private String createBeginDate;

    /**
     * 记录时间截止
     */
    @ApiModelProperty("记录时间截止")
    @SaturnColumn(description = "记录时间截止")
    private String createEndDate;
}
