package com.biz.crm.nebular.mdm.org.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 组织表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmOrgPageSelectReqVo", description = "组织分页选择列表查询请求参数")
public class MdmOrgPageSelectReqVo extends CrmTreeTenVo {

    @ApiModelProperty("组织编码，模糊查询")
    private String orgCode;

    @ApiModelProperty("组织名称，模糊查询")
    private String orgName;

    @ApiModelProperty("组织类型，精确查询")
    private String orgType;

    @ApiModelProperty("组织描述，模糊查询")
    private String orgDesc;

    @ApiModelProperty("上级组织编码，精确查询")
    private String parentCode;

    @ApiModelProperty("对应SAP组织编码，模糊查询")
    private String sapOrgCode;

    @ApiModelProperty("对应SAP组织编码利润中心编码，模糊查询")
    private String sapProfitOrgCode;

    @ApiModelProperty("对应SAP组织编码成本中心编码，模糊查询")
    private String sapCostOrgCode;

    @ApiModelProperty("企业组织编码，查询这个组织及全部下级企业组织（含当前组织）")
    private String allUnderThisOrgCodeIncludeSelf;

    @ApiModelProperty("企业组织编码，查询这个组织及全部下级企业组织（不含当前）")
    private String allUnderThisOrgCodeExcludeSelf;

    @ApiModelProperty("企业组织编码集合，查询这些组织及全部下级企业组织（含当前组织）")
    private List<String> allUnderOrgCodeListIncludeSelf;

    @ApiModelProperty("企业组织编码集合，查询这些组织的全部下级组织（不含当前，如果参数本身有上下级关系，则要返回处于下级的组织）")
    private List<String> allUnderOrgCodeListExcludeSelf;

    @ApiModelProperty("企业组织编码集合，查询这些组织的全部下级组织（不含参数中的任意一个组织）")
    private List<String> allUnderOrgCodeListExcludeAnySelf;

}