package com.biz.crm.nebular.mdm.permission;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 数据权限请求vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmDataPermissionReqVo", description = "数据权限")
public class MdmDataPermissionReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("角色编码集合")
    private List<String> roleCodeList;

    @ApiModelProperty("列表配置编码")
    private String listConfigCode;

    @ApiModelProperty("权限对象编码")
    private String permissionObjCode;

    @ApiModelProperty("菜单编码")
    private String functionCode;

    @ApiModelProperty("数据来源，数据字典：permission_resource")
    private String permissionResource;

    @ApiModelProperty("查询方式")
    private String permissionSearchType;

    @ApiModelProperty("组织集合")
    private List<MdmDataPermissionOrgVo> dataPermissionOrgVos;

    @ApiModelProperty("职位集合")
    private List<MdmDataPermissionPositionVo> dataPermissionPositionVos;

    @ApiModelProperty("渠道集合")
    private List<MdmDataPermissionChannelVo> dataPermissionChannelVos;

    @ApiModelProperty("终端集合")
    private List<MdmDataPermissionTerminalVo> dataPermissionTerminalVos;

    @ApiModelProperty("客户集合")
    private List<MdmDataPermissionCustomerVo> dataPermissionCustomerVos;

    @ApiModelProperty("客户组织集合")
    private List<MdmDataPermissionCustomerOrgVo> dataPermissionCustomerOrgVos;

}