package com.biz.crm.nebular.mdm.product.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 产品和产品层级请求VO
 *
 * @author Tao.Chen
 * @date 2020-12-02 11:01:25
 */
@Data
@ApiModel(value = "产品和产品层级请求VO")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MdmProductAndProductLevelReqVo implements Serializable {

    @ApiModelProperty("返回条数，不传返回默认数量")
    private Integer pageSize;

    @ApiModelProperty("编码或者名称：模糊查询商品编码、商品名称、层级编码、层级名称")
    private String codeOrName;

    @ApiModelProperty("产品层级编码，精确查询产品层级关联产品（传了该参数则只会返回商品）")
    private String productLevelCode;

    @ApiModelProperty("类型：精确查询level或者product")
    private String type;

}
