package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户关联客户分页查询响应
 *
 * @author zxw
 * @date 2020-10-12 10:04
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationCustomerPageRespVo", description = "用户关联客户分页查询响应")
@CrmColumnResolve
public class MdmUserRelationCustomerPageRespVo extends CrmExtVo {

    @ApiModelProperty("渠道")
    private String channel;

    @Deprecated
    @ApiModelProperty("渠道")
    @CrmDict(typeCode = "channel", dictCodeField = "channel")
    private String channelName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @Deprecated
    @ApiModelProperty("客户类型")
    @CrmDict(typeCode = "customer_type", dictCodeField = "customerType")
    private String customerTypeName;

    @ApiModelProperty("所属组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("supply表id")
    private String supplyId;
}
