package com.biz.crm.nebular.rebate.rebatedetail;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Author: huojia
 * @DateTime: 2021/1/12 15:06
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利明细计算日志vo")
public class RebateComputeLogVo extends CrmExtVo {

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;
    /**
     * 返利政策编码
     */
    @ApiModelProperty(value = "返利政策编码")
    private String rebateCode;
    /**
     * 返利明细编码
     */
    @ApiModelProperty(value = "返利明细编码")
    private String detailCode;
    /**
     * 返利明细名称
     */
    @ApiModelProperty(value = "返利明细名称")
    private String detailName;
    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String cusCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String cusName;
    /**
     * 公式编码
     */
    @ApiModelProperty(value = "公式编码")
    private String expressionCode;
    /**
     * 返利商品编码
     */
    @ApiModelProperty(value = "返利商品编码")
    private String computeProductCode;
    /**
     * 计算年月
     */
    @ApiModelProperty(value = "计算年月")
    private String computeYearMonth;
    /**
     * 计算时间
     */
    @ApiModelProperty(value = "计算时间")
    private String computeTime;
    /**
     * 条件公式
     */
    @ApiModelProperty(value = "条件公式")
    private String conditionExpression;
    /**
     * 条件公式获取变量传递参数
     */
    @ApiModelProperty(value = "条件公式获取变量传递参数")
    private String conditionProperties;
    /**
     * 计算公式获取变量传递参数
     */
    @ApiModelProperty(value = "计算")
    private String computeProperties;
    /**
     * 计算公式
     */
    @ApiModelProperty(value = "计算公式")
    private String computeExpression;
    /**
     * 条件变量结果
     */
    @ApiModelProperty(value = "条件变量结果")
    private String conditionValues;
    /**
     * 计算变量结果
     */
    @ApiModelProperty(value = "计算变量结果")
    private String computeValues;
    /**
     * 条件公式计算结果
     */
    @ApiModelProperty(value = "条件公式计算结果")
    private Boolean conditionResult;
    /**
     * 计算公式计算结果
     */
    @ApiModelProperty(value = "计算公式计算结果")
    private BigDecimal computeResult;
    /**
     * 是否测试，0：否，1：是
     */
    @ApiModelProperty(value = "是否测试")
    private Integer isTest = 0;
    /**
     * 计算批次号
     */
    @ApiModelProperty(value = "计算批次号")
    private String speedNo;
}