package com.biz.crm.nebular.rebate.rebatepolicy;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.nebular.rebate.expression.RebateExpressionVo;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: huojia
 * @DateTime: 2021/1/11 14:11
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利政策的vo")
public class RebateVo extends CrmExtVo {
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 返利类型(字典+枚举)
     */
    @ApiModelProperty(value = "返利类型(字典+枚举)")
    private Integer rebateType;

    /**
     * 上账类型(字典+枚举)
     */
    @ApiModelProperty(value = "上账类型(字典+枚举)")
    private Integer onAccountType;

    /**
     * 政策开始时间
     */
    @ApiModelProperty(value = "政策开始时间")
    private String rebateStartDate;

    /**
     * 政策结束时间
     */
    @ApiModelProperty(value = "政策结束时间")
    private String rebateEndDate;

    /**
     * 政策可申请时间
     */
    @ApiModelProperty(value = "政策可申请时间")
    private String applyStartDate;

    /**
     * 政策可申请结束时间
     */
    @ApiModelProperty(value = "政策可申请结束时间")
    private String applyEndDate;

    /**
     * 费率
     */
    @ApiModelProperty(value = "费率")
    private BigDecimal rate;

    /**
     * 是否有效（字典）：启用状态，0：禁用，1：启用，默认启用状态
     */
    private Integer effectiveFlag = 1;

    /**
     * 考核商品
     */
    @ApiModelProperty(value = "考核商品")
    private List<RebateProductVo> assessProductList = new ArrayList<>();

    /**
     * 返利产品
     */
    @ApiModelProperty(value = "返利商品")
    private List<RebateProductVo> rebateProductList = new ArrayList<>();

    /**
     * 范围信息（组织-包含）
     */
    @ApiModelProperty(value = "范围信息（组织-包含）")
    private List<RebateAreaVo> organizations = new ArrayList<>();

    /**
     * 范围信息（组织-非包含）
     */
    @ApiModelProperty(value = "范围信息（组织-非包含）")
    private List<RebateAreaVo> nonOrganizations = new ArrayList<>();

    /**
     * 范围信息（客户-包含）
     */
    @ApiModelProperty(value = "范围信息（客户-包含）")
    private List<RebateAreaVo> customers = new ArrayList<>();

    /**
     * 范围信息（客户-非包含）
     */
    @ApiModelProperty(value = "范围信息（客户-非包含）")
    private List<RebateAreaVo> nonCustomers = new ArrayList<>();

    /**
     * 返利公式
     */
    @ApiModelProperty(value = "返利公式")
    private List<RebateExpressionVo> rebateExpressionVos = new ArrayList<>();

    /**
     * 计算状态，0：未计算，1：已计算
     */
    @ApiModelProperty(value = "计算状态")
    private Integer isCompute = 0;
}