package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤(进离店) 返回vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤(进离店) ")
@SaturnEntity(name = "SfaVisitStepInoutRespVo", description = "拜访步骤(进离店) ")
public class SfaVisitStepInoutRespVo extends CrmExtVo {

    @ApiModelProperty("拜访编码 关联拜访计划")
    @SaturnColumn(description = "拜访编码 关联拜访计划")
    private String visitId;

    @ApiModelProperty("拜访类型")
    @SaturnColumn(description = "拜访类型")
    private String visitType;

    @ApiModelProperty("拜访类型日期")
    @SaturnColumn(description = "拜访类型日期")
    private String visitDate;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    @SaturnColumn(description = "网点类型")
    private String clientType;

    @ApiModelProperty("进店时间")
    @SaturnColumn(description = "进店时间")
    private String inTime;

    @ApiModelProperty("进店地址")
    @SaturnColumn(description = "进店地址")
    private String inAddress;

    @ApiModelProperty("离店时间")
    @SaturnColumn(description = "离店时间")
    private String outTime;

    @ApiModelProperty("离店地址")
    @SaturnColumn(description = "离店地址")
    private String outAddress;

}