package com.biz.crm.nebular.sfa.worksign.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请假申请列表查询 请求vo
 *
 * @author liuhongming
 * @date 2020-11-19 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaLeaveListReqVo", description = "请假申请列表查询请求 ")
public class SfaLeaveListReqVo extends PageVo {

    @ApiModelProperty("关键字")
    private String keyWord;

    @ApiModelProperty("请假类型 请假类型")
    private String leaveType;

    @ApiModelProperty("人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("申请日期开始 (yyyy-MM-dd)")
    private String applicationDateStart;
    @ApiModelProperty("申请日期结束 (yyyy-MM-dd)")
    private String applicationDateEnd;

    @ApiModelProperty("请假开始时间开始 (yyyy-MM-dd)")
    private String beginTimeStart;
    @ApiModelProperty("请假开始时间结束 (yyyy-MM-dd)")
    private String beginTimeEnd;

    @ApiModelProperty("请假结束时间开始 (yyyy-MM-dd)")
    private String endTimeStart;
    @ApiModelProperty("请假结束时间结束 (yyyy-MM-dd)")
    private String endTimeEnd;

    @ApiModelProperty("审批状态 审批状态")
    private String bpmStatus;

    @ApiModelProperty("审批状态 多选")
    private List<String> bpmStatusList;

    @ApiModelProperty("考勤审核类型(1待审核，2已审批)")
    private String auditType;

    @ApiModelProperty("审核任务id集合")
    List<String> auditTaskIdList;

}