package com.bizunited.platform.kuiper.starter.common.excel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * excel 导入bean注解
 *
 * @author Keller
 * @create 2020/8/24
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface NebulaExcelImport {

  /**
   * 开始解析行数
   */
  int startRow() default 0;

  /**
   * 开始解析列数
   */
  int startColumn() default 0;

  /**
   * 结束解析列数
   */
  int endColumn() default -1;

  /**
   * excel中读取sheet索引 默认为0第一个sheet
   */
  int sheetIndex() default 0;
}
