package com.biz.crm.nebular.activiti.act.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-12-08
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "ProcessCostTypeQueryVo", description = "流程业务关联配置查询请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class ProcessCostTypeQueryVo {

    @ApiModelProperty(value = "业务流程类型", required = false)
    private String costType;

    @ApiModelProperty(value = "业务来源系统", required = false)
    private String formType;

    @ApiModelProperty(value = "业务流程细类", required = false)
    private String smallType;

}
