package com.biz.crm.nebular.activiti.act.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返回vo
 *
 * @author jerry7
 * @date 2021-01-11 16:39:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "委托代理回显类")
@CrmColumnResolve
public class TaAgencyApprovalRespVo  {

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("被代理人的岗位编码")
    private String fromPosCode;

    @ApiModelProperty("被代理人的岗位名称")
    private String fromPosName;

    @ApiModelProperty("被代理人的用户编码")
    private String fromUserCode;

    @ApiModelProperty("被代理人的用户名称")
    private String fromUserName;

    @ApiModelProperty("代理人的岗位编码")
    private String proxyPosCode;

    @ApiModelProperty("代理人的岗位名称")
    private String proxyPosName;

    @ApiModelProperty("代理人的用户编码")
    private String proxyUserCode;

    @ApiModelProperty("代理人的用户名称")
    private String proxyUserName;

    @ApiModelProperty("代理开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date proxyStartTime;

    @ApiModelProperty("代理结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date proxyEndTime;

    @ApiModelProperty("是否代理全部流程，0-否，1-是")
    private Integer allProxy;

    @ApiModelProperty("代理状态")
    private String allProxyName;

    @ApiModelProperty("代理的流程key集合")
    private List<TaProxyProcessRspVo> processKeyList;

}