package com.biz.crm.nebular.activiti.task.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * @author weston
 * @date 2020-11-26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "流程信息响应vo")
@SaturnEntity(name = "ProcessInfoRspVO", description = "流程信息响应vo")
@CrmColumnResolve
public class ProcessInfoRspVO {

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "表单编码")
    private String formNo;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "发起人编码")
    private String applierCode;

    @ApiModelProperty(value = "发起人名称")
    private String applierName;

    @ApiModelProperty(value = "发起人职位编码")
    private String applierPositionCode;

    @ApiModelProperty(value = "发起人职位名称")
    private String applierPositionName;

    @ApiModelProperty(value = "流程状态")
    private Integer status;

    @ApiModelProperty(value = "流程Key")
    private String processKey;

    @ApiModelProperty(value = "流程实例ID")
    private String processInstanceId;

    @ApiModelProperty(value = "父流程实例ID")
    private String parentProcessInstId;

    @ApiModelProperty(value = "导致流程的原因类型(1=正常发起2=驳回3=转发=4加签5=子流程)")
    private Integer causeType;

    @ApiModelProperty(value = "流程发起时间")
    private Date startTime;

    @ApiModelProperty(value = "表单业务类型")
    private String costType;

    @ApiModelProperty(value = "表单来源系统")
    private String formType;

    @ApiModelProperty(value = "表单展示的URL")
    private String formUrl;

    @ApiModelProperty(value = "细类")
    private String smallType;

    @ApiModelProperty(value = "流程版本号")
    private String processVersionKey;

    @ApiModelProperty(value = "表单快照URL(驳回和撤销的流程有值)")
    private String htmlUrl;

    @ApiModelProperty(value = "节点状态类型 1=历史节点 2=当前待办节点")
    private Integer taskType;

    @ApiModelProperty(value = "节点实例ID")
    private String taskId;

    @ApiModelProperty(value = "节点定义Key")
    private String taskDefKey;

    @ApiModelProperty(value = "按钮权限")
    private String btnAuths;

    @ApiModelProperty(value = "按钮列表")
    private List<OptBtnVO> btnList;

    @ApiModelProperty(value = "是否允许移动审批")
    private Boolean allowMobile;

    @ApiModelProperty(value = "本节点待办人编码")
    private String currentUserCode;

    @ApiModelProperty(value = "本节点待办人名称")
    private String currentUserName;

    @ApiModelProperty(value = "本节点待办人职位编码")
    private String currentUserPositionCode;

    @ApiModelProperty(value = "本节点待办人职位名称")
    private String currentUserPositionName;

    @ApiModelProperty(value = "流程上一个操作人编码")
    private String lastUserCode;

    @ApiModelProperty(value = "流程上一个操作人名称")
    private String lastUserName;

    @ApiModelProperty(value = "流程上一个操作人职位编码")
    private String lastUserPositionCode;

    @ApiModelProperty(value = "流程上一个操作人职位名称")
    private String lastUserPositionName;

    @ApiModelProperty(value = "流程上一个操作人操作动作")
    private String lastOptBtn;

    @ApiModelProperty(value = "流程上一个操作人操作动作描述")
    private String lastOptBtnDesc;

    @ApiModelProperty(value = "流程上一个操作人操作备注")
    private String lastOptRemark;

    @ApiModelProperty(value = "沟通内容")
    private String communicateContent;

    @ApiModelProperty(value = "流程提交文件")
    List<TaActFileRespVo> startFiles;

    @ApiModelProperty(value = "流程审批文件")
    List<TaActFileRespVo> ApproveFiles;
}
