package com.biz.crm.nebular.dms.contract;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同销售范围的vo")
@SaturnEntity(name = "ContractSalesAreaVo", description = "合同销售范围")
@SaturnDomain(value = "contractsalesarea")
public class ContractSalesAreaVo extends CrmExtVo {

    @ApiModelProperty(value = "合同ID")
    @SaturnColumn(description = "合同ID")
    private String contractId;

    @ApiModelProperty(value = "国家编码")
    @SaturnColumn(description = "国家编码")
    private String countryCode;

    @ApiModelProperty(value = "国家")
    @SaturnColumn(description = "国家")
    private String country;

    @ApiModelProperty(value = "省编码")
    @SaturnColumn(description = "省编码")
    private String provinceCode;

    @ApiModelProperty(value = "省")
    @SaturnColumn(description = "省")
    private String province;

    @ApiModelProperty(value = "市编码")
    @SaturnColumn(description = "市编码")
    private String cityCode;

    @ApiModelProperty(value = "市")
    @SaturnColumn(description = "市")
    private String city;

    @ApiModelProperty(value = "区县编码")
    @SaturnColumn(description = "区县编码")
    private String districtCode;

    @ApiModelProperty(value = "区县")
    @SaturnColumn(description = "区县")
    private String district;

    @ApiModelProperty(value = "乡镇编码")
    @SaturnColumn(description = "乡镇编码")
    private String townshipCode;

    @ApiModelProperty(value = "乡镇")
    @SaturnColumn(description = "乡镇")
    private String township;

    @ApiModelProperty(value = "是否包含")
    private Integer containFlag;
}
