package com.biz.crm.nebular.dms.order;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Author: huojia
 * @DateTime: 2021/1/28 20:40
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单商品的vo")
public class OrderDetailVo extends CrmExtTenVo {

    /**
     * 订单id
     */
    @ApiModelProperty(value = "订单id")
    private String orderCode;

    /**
     * 行号
     */
    @ApiModelProperty(value = "行号")
    private String lineNo;

    /**
     * 行项目类型
     */
    @ApiModelProperty(value = "行项目类型")
    private String lineType;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String productCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String productName;

    /**
     * 规格
     */
    @ApiModelProperty(value = "规格")
    private String spec;

    /**
     * 数量
     */
    @ApiModelProperty(value = "数量")
    private BigDecimal productNum;

    /**
     * 总重量(克)
     */
    @ApiModelProperty(value = "总重量(克)")
    private BigDecimal weightOfGram;

    /**
     * 总重量(千克)
     */
    @ApiModelProperty(value = "总重量(千克)")
    private BigDecimal weightOfKilogram;

    /**
     * 总重量(吨)
     */
    @ApiModelProperty(value = "总重量(吨)")
    private BigDecimal weightOfTon;

    /**
     * 销售单位编码
     */
    @ApiModelProperty(value = "销售单位编码")
    private String salesUnit;

    /**
     * 销售单位名称
     */
    @ApiModelProperty(value = "销售单位名称")
    private String salesUnitName;

    /**
     * 单价
     */
    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    /**
     * 本行总金额
     */
    @ApiModelProperty(value = "本行总金额")
    private BigDecimal amount;

    /**
     * 订单明细促销id
     */
    @ApiModelProperty(value = "订单明细促销id")
    private String orderDetailPromotionId;

    /**
     * 促销code
     */
    @ApiModelProperty(value = "促销code")
    private String promotionCode;

    /**
     * 促销名称
     */
    @ApiModelProperty(value = "促销名称")
    private String promotionName;

    /**
     * 政策叠加 字典：yesOrNo
     */
    @ApiModelProperty(value = "政策叠加 字典：yesOrNo")
    private String multipleable;
    @ApiModelProperty(value = "分组编码")
    private String groupCode;

    @ApiModelProperty(value = "促销编码",notes = "非必须")
    private String promotionPolicyCode;

    @ApiModelProperty(value = "促销名称",notes = "如果有促销编码则必须")
    private String promotionPolicyName;
    @ApiModelProperty(value = "默认商品图片")
    private String imgUrl;

}