package com.biz.crm.nebular.dms.promotion;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 *  @author: luoqi
 *  @Date: 2020-10-16 14:28
 *  @version: V1.0
 *  @Description:
 */
@Data
@SaturnEntity(name = "PromotionRuleSelectionVo", description = "模板规则选择")
public class PromotionRuleSelectionVo {
    /**
     * ID
     */
    @SaturnColumn(description = "规则ID")
    @ApiModelProperty(value = "ID")
    private String id;
    /**
     * 规则名称
     */
    @SaturnColumn(description = "规则名称")
    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    /**
     * 规则编码
     */
    @SaturnColumn(description = "规则编码")
    @ApiModelProperty(value = "规则编码")
    private String ruleCode;

    /**
     * 规则类型
     */
    @SaturnColumn(description = "规则类型")
    @ApiModelProperty(value = "规则类型")
    private String ruleType;
    /**
     * 促销类型
     */
    @SaturnColumn(description = "促销类型")
    @ApiModelProperty(value = "促销类型")
    private String promotionType;
    /**
     * 备注
     */
    @SaturnColumn(description = "备注")
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 调试参数(k-v)
     */
    @SaturnColumn(description = "调试参数")
    @ApiModelProperty(value = "调试参数")
    private String testParam;
    /**
     * 选中
     */
    @SaturnColumn(description = "选中")
    @ApiModelProperty(value = "选中")
    private Boolean selected = false;
}
