package com.biz.crm.nebular.dms.salecontract;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.nebular.dms.contractupdatingfiles.ContractUpdatingFilesVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同vo
 * @Author: chenrong
 * @Date: 2021/2/17 11:31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同vo")
public class SaleContractVo extends CrmExtTenVo {

  /**
   * 合同编码
   */
  private String code;
  /**
   * 合同名称
   */
  private String name;
  /**
   * 模板编码
   */
  private String templateCode;
  /**
   * 合同类型
   */
  private String contractType;
  /**
   * 合同年度
   */
  private String yearly;
  /**
   * 客户编码
   */
  private String cusCode;
  /**
   * 客户名称
   */
  private String cusName;
  /**
   * 渠道类型
   */
  private String channelCode;
  /**
   * 渠道名称
   */
  private String channelName;
  /**
   * 所属组织编码
   */
  private String orgCode;
  /**
   * 所属组织名称
   */
  private String orgName;
  /**
   * 合同开始时间
   */
  private String startTime;
  /**
   * 合同结束时间
   */
  private String endTime;
  /**
   * 各个模块的json数据
   */
  @ApiModelProperty(hidden = true)
  private JSONObject data;
  /**
   * 合同模板对象
   */
  private ContractTemplateVo contractTemplateVo;
  /**
   * 冗余字段：文件列表
   */
  private List<ContractUpdatingFilesVo> filesVo;
}
