package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池明细日志表请求vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDetailLogReqVo", description = "费用池明细表日志表")
public class FeePoolDetailLogReqVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("操作时间 yyyy-MM-dd HH:mm:ss")
    private String operationDateTime;

    @ApiModelProperty("操作金额（元）（含正负）")
    private BigDecimal operationAmount;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("支付方式")
    private String payType;

}