package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 客户费用池金额汇总查询返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户费用池金额汇总查询返回vo")
@CrmColumnResolve
public class FeePoolAmountRespVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("已冻结金额")
    private BigDecimal freezeAmount;

    @ApiModelProperty("已使用金额")
    private BigDecimal hasUseAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal usableAmount;

    @Deprecated
    private BigDecimal useAmount;

    public BigDecimal getUseAmount() {
        return hasUseAmount;
    }

}