package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 货补费用池调整加载数据返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "货补费用池调整加载数据")
@CrmColumnResolve
public class FeePoolQueryForAdjustRespVo extends CrmExtTenVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("费用池类型")
    private String poolType;

    @ApiModelProperty("渠道类型")
    private String channelType;

    @ApiModelProperty("组织编码(可能是集合，英文逗号间隔)")
    private String orgCode;

    @ApiModelProperty("组织名称(可能是集合，英文逗号间隔)")
    private String orgName;

    @ApiModelProperty("折扣费用池类型")
    private String discountType;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("冻结金额")
    private BigDecimal freezeAmount;

    @ApiModelProperty("已使用金额")
    private BigDecimal hasUseAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal usableAmount;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("折扣类型可选项")
    private List<FeeSelectOptionVo> discountTypeList;

    @ApiModelProperty("支付方式可选项")
    private List<FeeSelectOptionVo> payTypeList;

    @ApiModelProperty("调整类型可选项")
    private List<FeeSelectOptionVo> operationTypeSelectList;

    @Deprecated
    private BigDecimal useAmount;

    public BigDecimal getUseAmount() {
        return hasUseAmount;
    }

}