package com.biz.crm.nebular.mdm.notice.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 公告发布范围 请求vo
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaNoticeReceivingReqVo", description = "公告发布范围 ")
public class MdmNoticeReceivingReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("编码 编码")
    private String receivingCode;

    @ApiModelProperty("名称 名称")
    private String receivingName;

    @ApiModelProperty("范围类型 范围类型(10:当前组织;20:当前组织及下级组织)")
    private String receivingType;

    @ApiModelProperty("公告编码 公告编码")
    private String noticeCode;

    @ApiModelProperty("公告编码集合")
    private List<String> noticeCodes;

}