package com.biz.crm.nebular.mdm.parametermanage.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 参数配置返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-24 10:47:10
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "参数配置")
public class MdmParameterManageRespVo extends CrmBaseVo {

    @ApiModelProperty("参数")
    private String parameterCode;

    @ApiModelProperty("参数名称")
    private String parameterName;

    @ApiModelProperty("默认值")
    private String defaultValue;

    @ApiModelProperty("参数值")
    private String parameterValue;

    @ApiModelProperty("参数说明")
    private String parameterExplain;

    @ApiModelProperty("所属模块")
    private String parameterModule;

    @ApiModelProperty("所属模块名称")
    @CrmDict(typeCode = DictConstant.MODULE_GROUP, dictCodeField = "parameterModule")
    private String parameterModuleName;

}