package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author ql
 * @date 2021/2/4
 * @time 14:59
 * 终端用户新增/编辑请求vo
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmTerminalUserEditReqVo", description = "终端用户新增/编辑请求vo")
public class MdmTerminalUserEditReqVo extends CrmExtTenVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("密码（经过加密的）")
    private String userPassword;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("终端列表")
    private List<MdmUserTerminalEditReqVo> terminalList;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;
}
