package com.biz.crm.nebular.rebate.rebatedetail;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * web端计算返利传入参数对象
 * @Author: chenrong
 * @Date: 2021/1/18 10:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利计算参数对象")
public class RebateComputeWebParam implements Serializable {

  private static final long serialVersionUID = 6556401889285197883L;

  /**
   * 返利政策编码列表
   */
  @ApiModelProperty(value = "返利政策编码列表")
  private List<String> codes;
  /**
   * 当前计算时间
   */
  @ApiModelProperty(value = "当前计算时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date computeTime;
  /**
   * 返利名称
   */
  @ApiModelProperty(value = "返利名称")
  private String rebateTitle;
  /**
   * 是否测试
   */
  @ApiModelProperty(value = "是否测试")
  private Integer isTest;
}
