package com.biz.crm.nebular.sfa.calculateSalary.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 计算薪资日期请求vo
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaCalculateSalaryDateReqVo", description = "计算薪资日期")
public class SfaCalculateSalaryDateReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("年份")
    private String year;

    @ApiModelProperty("日期")
    private String day;

    @ApiModelProperty("是否计算薪资(0-否,1-是)")
    private String isCalculationSalary;

    @ApiModelProperty("节假日名称")
    private String salary;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

}