package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 拜访步骤(店面检查);请求vo
 *
 * @author lf
 * @date 2020-12-29 23:06:39
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepStoreCheckReqVo", description = "拜访步骤(店面检查);")
public class SfaVisitStepStoreCheckReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访id")
    private String visitDetailId;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("检查时间")
    private String checkTime;

    @ApiModelProperty("检查项(0-常规货架陈列,1-物料陈列,2-价格签)")
    private String checkType;

    @ApiModelProperty("检查地址")
    private String checkAddress;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("维度")
    private String latitude;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("常规货架检查列表")
    private List<SfaVisitPictureReqVo> regularShelfDisplayList;

    @ApiModelProperty("物料陈列列表")
    private List<SfaVisitPictureReqVo> materialDisplayList;

    @ApiModelProperty("价格签列表")
    private List<SfaVisitPictureReqVo> priceList;

}