package com.biz.crm.common.param;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.base.param
 * @Description: TODO
 * @date 2020/8/28 下午1:08
 */
public class RedisParam {
    /**
     * 缓存key 分隔符
     */
    public static final String DELIMITER = ":";

    public static final int TIME1 = 1;
    public static final int TIME3 = 3;
    public static final int TIME5 = 5;
    public static final int TIME10 = 10;
    public static final int TIME30 = 30;
    public static final int TIME365 = 365;
    public static final int YEAR5 = 365*5;
    public static final int MONTH1 = 30*24*60*60;
    public static final int MONTH3 = 30*24*60*60*3;
    public static final int YEAR2 = 60*60*24*365*2;
    public static final int SECONDS_OF_FIVE_MINUTE = 60*5;
    public static final int SECONDS_OF_DAY = 60*60*24;
    public static final int SECONDS_OF_HOUR = 60*60;
    public static final int SECONDS_OF_MONTH = 60*60*24*30;
    //当前用户登录，token与用户关系前缀
    public static final String LOGIN_USER_TOKEN_PREFIX = "LOGIN_USER_TOKEN_";

    //数据字典类型编码
    public static final String DICT_TYPE_LOCK = "DICT_TYPE_LOCK_1231:";
    public static final String DICT_TYPE_GROUP = "DICT_TYPE_GROUP_1231:";

    //企业组织缓存
    public static final String MDM_ORG_LOCK_HASH = "MDM_ORG_LOCK_HASH_0112:";
    public static final String MDM_ORG_PARENT_HASH = "MDM_ORG_PARENT_HASH_0112:";
    public static final String MDM_ORG_CHILDREN_HASH = "MDM_ORG_CHILDREN_HASH_0112:";
    public static final String MDM_ORG_SELF_HASH = "MDM_ORG_SELF_HASH_0112:";

    //流程角色缓存
    public static final String MDM_BPM_ROLE_LOCK_HASH = "MDM_BPM_ROLE_LOCK_HASH_0112:";
    public static final String MDM_BPM_ROLE_SELF_HASH = "MDM_BPM_ROLE_SELF_HASH_0112:";

    //职位缓存
    public static final String MDM_POSITION_LOCK_HASH = "MDM_POSITION_LOCK_HASH_0407:";
    public static final String MDM_POSITION_PARENT_HASH = "MDM_POSITION_PARENT_HASH_0407:";
    public static final String MDM_POSITION_CHILDREN_HASH = "MDM_POSITION_CHILDREN_HASH_0407:";
    public static final String MDM_POSITION_SELF_HASH = "MDM_POSITION_SELF_HASH_0407:";

    //产品层级缓存
    public static final String MDM_PRODUCT_LEVEL_LOCK_HASH = "MDM_PRODUCT_LEVEL_LOCK_HASH_0112:";
    public static final String MDM_PRODUCT_LEVEL_PARENT_HASH = "MDM_PRODUCT_LEVEL_PARENT_HASH_0112:";
    public static final String MDM_PRODUCT_LEVEL_CHILDREN_HASH = "MDM_PRODUCT_LEVEL_CHILDREN_HASH_0112:";
    public static final String MDM_PRODUCT_LEVEL_SELF_HASH = "MDM_PRODUCT_LEVEL_SELF_HASH_0112:";

    //客户组织缓存
    public static final String MDM_CUSTOMER_ORG_LOCK_HASH = "MDM_CUSTOMER_ORG_LOCK_HASH_0201:";
    public static final String MDM_CUSTOMER_ORG_PARENT_HASH = "MDM_CUSTOMER_ORG_PARENT_HASH_0201:";
    public static final String MDM_CUSTOMER_ORG_CHILDREN_HASH = "MDM_CUSTOMER_ORG_CHILDREN_HASH_0201:";
    public static final String MDM_CUSTOMER_ORG_SELF_HASH = "MDM_CUSTOMER_ORG_SELF_HASH_0201:";

    //个性设置
    public static final String MDM_COLUMN_CONFIG_PERSONAL = "MDM_COLUMN_CONFIG_PERSONAL_0313:";
    public static final String MDM_COLUMN_CONFIG_PERSONAL_LOCK = "MDM_COLUMN_CONFIG_PERSONAL_LOCK_0313:";

    //审批配置
    public static final String MDM_APPROVAL_CONFIG = "MDM_APPROVAL_CONFIG_0502:";
    public static final String MDM_APPROVAL_CONFIG_LOCK = "MDM_APPROVAL_CONFIG_LOCK_0502:";

    /**
     * 菜单缓存
     */
    public static final String MDM_FUNCTION = "MDM_FUNCTION414:";


    /**
     * SFA拜访相关
     */
    public static final String SFA_VISIT = "SFA_VISIT";
    /**
     * SFA任务
     */
    public static final String SFA_JOB = "SFA_JOB";
    /***全局参数前缀*/
    public static final String PARAMETER = "PARAMETER_:";
    /***全局参数加锁前缀*/
    public static final String PARAMETER_LOCK = "PARAMETER_LOCK_:";
    //错误一次编码
    public static final String ERROE_CODE="ERROE_CODE_";
    //错误编码前缀
    public static final String ERROE_MSG="ERROE_MSG_:";

    public static final String USER_GROUP_PREFIX = "user_group_0324:";

    /*----------------登录相关----------------*/
    /***用户账号锁定hash表前缀*/
    public static final String LOGIN_LOCK_USER = "LOGIN_LOCK_USER_0319:";
    /***用户账号密码错误次数hash表前缀*/
    public static final String LOGIN_LOCK_USER_ERROR_TIMES = "LOGIN_LOCK_USER_ERROR_TIMES_0319:";
    /***用户手机号锁定hash表前缀*/
    public static final String LOGIN_LOCK_PHONE = "LOGIN_LOCK_PHONE_0319:";
    /***用户手机号密码错误次数hash表前缀*/
    public static final String LOGIN_LOCK_PHONE_ERROR_TIMES = "LOGIN_LOCK_PHONE_ERROR_TIMES_0319:";
    /***用户手机号登录验证码hash表前缀*/
    public static final String LOGIN_PHONE_VERIFICATION = "LOGIN_PHONE_VERIFICATION_0319:";
    /***用户手机号重置密码验证码hash表前缀*/
    public static final String LOGIN_PHONE_RESET_VERIFICATION = "LOGIN_PHONE_RESET_VERIFICATION_0319:";
    /***用户邮箱锁定hash表前缀*/
    public static final String LOGIN_LOCK_EMAIL = "LOGIN_LOCK_EMAIL_0319:";
    /***用户邮箱密码错误次数hash表前缀*/
    public static final String LOGIN_LOCK_EMAIL_ERROR_TIMES = "LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:";
    /***用户邮箱登录验证码hash表前缀*/
    public static final String LOGIN_EMAIL_VERIFICATION = "LOGIN_EMAIL_VERIFICATION_0319:";
    /***用户邮箱重置验证码验证码hash表前缀*/
    public static final String LOGIN_EMAIL_RESET_VERIFICATION = "LOGIN_EMAIL_RESET_VERIFICATION_0319:";


    /***用户手机号注册验证码hash表前缀*/
    public static final String REGISTER_PHONE_VERIFICATION = "REGISTER_PHONE_VERIFICATION_0319:";

    /**
     * 页面配置
     */
    public static final String TABLE_CONFIG = "table_config:";

    /**
     * 员工通讯录
     */
    public static final String MDM_EMPLOYEE_DIRECTORY = "MDM_EMPLOYEE_DIRECTORY:";
    //mq消息日志id
    public static final String MQ_MESSAGE="MQ_MESSAGE:";

    //APP版本
    public static final String APP_VERSION = "APP_VERSION:";

}
