package com.biz.crm.message;

import lombok.Data;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.message
 * @Description: TODO
 * @date 2021/3/24 下午3:00
 */
@Data
public class ShortMessage {
    ////必填:待发送手机号。支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式；发送国际/港澳台消息时，接收号码格式为国际区号+号码，如“85200000000”
    private String phoneNumbers;
    private String signName;
    private String templateCode;
    //友情提示:如果JSON中需要带换行符,请参照标准的JSON协议对换行符的要求,比如短信内容中包含\r\n的情况在JSON中需要表示成\\r\\n,否则会导致JSON在服务端解析失败
    //参考：{"变量1":"值1","变量2":"值2","变量3":"值3"}
    private String templateParam;
    //可选-上行短信扩展码(扩展码字段控制在7位或以下，无特殊需求用户请忽略此字段)
    private String smsUpExtendCode;
    //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
    private String outId;
    /**非必填*/
    private String regionId;
}
