package com.biz.crm.nebular.activiti.design.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author jerry7
 * @date 2021-01-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "流程与组织信息响应VO")
@SaturnEntity(name = "TaProcessInfoRespVO", description = "流程定义基本信息响应VO")
@CrmColumnResolve
public class TaProcessOrgRespVO {


    @ApiModelProperty(value = "流程定义KEY")
    private String processKey;

    @ApiModelProperty(value = "流程定义名称")
    private String processName;

    @ApiModelProperty(value = "业务编码")
    private String bizCode;

    @ApiModelProperty(value = "业务名称")
    private String bizName;

    @ApiModelProperty(value = "是否仅当前组织")
    private String isOnlyCurrentOrg;
}
