package com.biz.crm.nebular.activiti.start.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "ProcessInfoReqVO", description = "流程详细信息请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class ProcessInfoReqVO {

    @ApiModelProperty(value = "任务节点ID")
    private String taskId;

    @ApiModelProperty(value = "流程实例ID")
    private String processInstanceId;

    @ApiModelProperty(value = "表单单号(非必传)")
    private String formNo;

    @ApiModelProperty(value = "业务单据类型")
    private String costType;

    @ApiModelProperty(value = "业务单据来源系统")
    private String formType;

    @ApiModelProperty(value = "抄送节点ID，查询抄送的节点时必须传")
    private String copyTaskId;

    @ApiModelProperty(value = "流程回传NO")
    private String processNo;

    @ApiModelProperty(value = "沟通任务id")
    private String communicateId;
}
