package com.biz.crm.nebular.activiti.vo;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author dukaiming
 * @version 1.0
 * @date 2019/5/10
 */
@Data
public class ActivitiBusinessVo extends CrmExtTenVo {

    @ApiModelProperty(value = "流程key")
    private String processKey; //
    @ApiModelProperty(value = "流程名称")
    private String processName;
    @ApiModelProperty(value = "业务对象id主键")
    private String businessId; // 业务对象id

    @ApiModelProperty(value = "业务对象编码")
    private String businessNo; // 业务对象id
    @ApiModelProperty(value = "流程标题")
    private String processTitle; // 流程标题
    private String processDetail;
    private Map<String, Object> variables; //变量
    private List<String> attachmentList;
    @ApiModelProperty(value = "关键指标 json 数组")
    private String keyTargetListJson;
    private String targetTextWithHead;
    @ApiModelProperty(value = "流程附件信息")
    private List<AttachmentVo> attachmentVos;
    private String businessUrl;
    @ApiModelProperty(value = "业务类型")
    private String bizType;
    @ApiModelProperty(value = "流程发起人职位编码,空则默认当前登录人")
    private String positionCode;

    @ApiModelProperty(value = "发起人职位编码")
    private String commitPos;

    @ApiModelProperty(value = "发起人职位名称")
    private String commitPosName;

    @ApiModelProperty(value = "发起人编码")
    private String commitCode;

    @ApiModelProperty(value = "发起人名称")
    private String commitName;

    @ApiModelProperty(value = "发起人组织编码")
    private String commitByOrg;

    @ApiModelProperty(value = "发起人组织名称")
    private String commitByOrgName;

    @ApiModelProperty(value = "发起时的备注")
    private String remark;

    @ApiModelProperty(value = "菜单编码")
    private String menuCode;

    @ApiModelProperty(value = "回调feign")
    private String callBackFeign;

    @ApiModelProperty(value = "业务流程类型")
    private String costType;

    @ApiModelProperty(value = "业务来源系统")
    private String formType;
    @ApiModelProperty(value = "时间戳")
    private String timestamp;
}
