package com.biz.crm.nebular.dms.complaints;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "投诉建议主信息的vo")
@SaturnEntity(name = "ComplaintsVo", description = "投诉主信息")
@SaturnDomain(value = "complaints")
public class ComplaintsVo extends CrmExtTenVo {

    @ApiModelProperty(value = "投诉建议标题")
    @SaturnColumn(description = "投诉建议标题")
    private String complaintsTitle;

    @ApiModelProperty(value = "投诉建议单号")
    @SaturnColumn(description = "投诉建议单号")
    private String complaintsNo;

    @ApiModelProperty(value = "投诉建议类型")
    @SaturnColumn(description = "投诉建议类型")
    private String complaintsType;

    @CrmDict(typeCode="complaints_type",dictCodeField="complaintsType")
    @ApiModelProperty(value = "投诉建议类型名称")
    @SaturnColumn(description = "投诉建议类型名称")
    private String typeName;

    @ApiModelProperty(value = "投诉建议状态")
    @SaturnColumn(description = "投诉建议状态")
    private String complaintsStatus;

    @CrmDict(typeCode="complaints_status",dictCodeField="complaintsStatus")
    @ApiModelProperty(value = "投诉建议状态名称")
    @SaturnColumn(description = "投诉建议状态名称")
    private String statusName;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty(value = "投诉建议内容")
    @SaturnColumn(description = "投诉建议内容")
    private String content;


    @ApiModelProperty(value = "文件信息")
    @SaturnColumn(description = "文件信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<ComplaintsFileVo> files;

}
