package com.biz.crm.nebular.dms.contract;

import com.biz.crm.nebular.mdm.CrmFileVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同文件的vo")
@SaturnEntity(name = "ContractFileVo", description = "合同文件")
@SaturnDomain(value = "contractfile")
public class ContractFileVo extends CrmFileVo {

    @ApiModelProperty(value = "合同ID")
    @SaturnColumn(description = "合同ID")
    private String contractId;

    @ApiModelProperty(value = "文件显示顺序")
    @SaturnColumn(description = "文件显示顺序")
    private Integer sortNum;
}
