package com.biz.crm.nebular.dms.minbuynumofproduct;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 起订量vo
 *
 * @Author: huojia
 * @DateTime: 2021/1/25 17:05
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "起订量的vo")
public class MinBuyNumOfProductVo extends CrmExtVo {

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称")
    private String productName;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String cusName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    /**
     * 终端名称
     */
    @ApiModelProperty(value = "终端名称")
    private String terminalName;

    /**
     * 终端编码
     */
    @ApiModelProperty(value = "终端编码")
    private String terminalCode;

    /**
     * 维度类型（数据字典）
     */
    @ApiModelProperty(value = "维度类型")
    private String dimensionType;

    /**
     * 校验方式（字典+枚举）
     */
    @ApiModelProperty(value = "校验方式")
    private String verificationMode;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称")
    private String unitName;

    /**
     * 单位编码
     */
    @ApiModelProperty(value = "单位编码")
    private String unitCode;

    /**
     * 起订量
     */
    @ApiModelProperty(value = "起订量")
    private BigDecimal minOrderQuantity;

    /**
     * 启禁状态默认为启用，1：启用，0：禁用
     */
    @ApiModelProperty(value = "启禁状态")
    private Integer effectiveFlag = 1;

    /**
     * 新增判重时使用的onlyKey（产品+组织/客户/终端）
     */
    @ApiModelProperty(value = "判重")
    private String onlyKey;
}