package com.biz.crm.nebular.dms.notice;

import com.biz.crm.config.CrmDict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/21 16:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "公告前段查询返回的vo")
public class ListRes extends NoticeVo{

    @ApiModelProperty(value = "公告日志id")
    private String noticeLogId;

    @ApiModelProperty(value = "消息状态(0未读 1已读)")
    private Integer msgState;

    @ApiModelProperty(value = "消息状态名称")
    @CrmDict(typeCode="notice_msg_state",dictCodeField="msgState")
    private String msgStateName;
}
