package com.biz.crm.nebular.dms.npromotion.bo;

import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;

/**
 * 促销计算结果对象
 * @Author: chenrong
 * @Date: 2021/4/23 10:47
 */
@Data
public class CalculateResultBo implements Serializable {

  private static final long serialVersionUID = -2054220401351076238L;

  //计算结果类型 QTY_TYPE number:数量； amount:金额
  private String valueType;

  //计算结果单位类型 ProductUnitEnum  计算结果单位类型 数据字典：unit_type
  private String unitType;

  //计算结果
  private BigDecimal value;

  //使用的阶梯
  private List<PromotionRuleEditVo.ControlRow> ladderUsed;

  //阶梯匹配状态，只要有一个阶梯匹配上，就为true
  private boolean matchState;

  //未匹配到阶梯时的描述说明
  private String matchMsg;

  //政策中本品列表
  private List<PromotionProductVo> currentProductVos;
  //政策中的赠品列表
  private List<PromotionProductVo> giftProductVos;
}
