package com.biz.crm.nebular.dms.npromotion.vo;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 促销商品vo
 * @Author: chenrong
 * @Date: 2021/4/12 17:09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PromotionProductVo extends CrmExtTenVo {

  private static final long serialVersionUID = -5983882819433398504L;

  /**
   * 商品编码
   */
  private String productCode;


  /**
   * 商品名称
   */
  private String productName;

  /**
   * 本品赠品一一对应-赠品编码
   */
  private String productCodeGift;


  /**
   * 本品赠品一一对应-赠品名称
   */
  private String productNameGift;

  /**
   * 本品赠品
   */
  private String currentProduct;

  /**
   * 单品起订量类型 字典：products_order_qty_type
   */
  private String productOrderQtyType;

  /**
   * 单品起订量
   */
  private BigDecimal productOrderQty;


  /**
   * 政策id
   */
  private String promotionPolicyId;

  /**
   * 政策code
   */
  private String promotionPolicyCode;

  /**
   * 政策名称
   */
  private String promotionPolicyName;

  /**
   * 赠送比例，只有赠品才需要
   */
  @ApiModelProperty(name = "gift_ratio", value = "赠送比例，只有赠品才需要")
  private BigDecimal giftRatio;

  @ApiModelProperty(value = "冗余字段：最大赠送数量")
  private BigDecimal giftCountMax;

  @ApiModelProperty(value = "冗余字段：最大赠送金额")
  private BigDecimal giftAmountMax;
}
