package com.biz.crm.nebular.dms.npromotion.vo;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 促销政策命中查询，主要用于订单商品选择时，查询命中的促销政策
 * @Author: chenrong
 * @Date: 2021/4/16 10:00
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PromotionQueryReq extends CrmExtTenVo {

  private static final long serialVersionUID = -176066524483821791L;

  @ApiModelProperty(value = "账户编码，客户编码或组织编码或渠道编码或终端编码等等", required = true)
  private String accountCode;
  /**
   * {@link com.biz.crm.promotion.enums.AccountTypeDynamicEnum}
   */
  @ApiModelProperty(value = "账户类型，customer：经销商编码，terminal：终端编码", required = true)
  private String accountType;

  @ApiModelProperty(value = "组织编码")
  private String orgCode;

  @ApiModelProperty(value = "渠道编码")
  private String channelCode;

  @ApiModelProperty(value = "购买的商品列表")
  private List<PromotionSaleProductVo> saleProductVos;

  @ApiModelProperty(value = "促销政策编码")
  private List<String> promotionCodes;

  @ApiModelProperty(value = "促销政策对象", hidden = true)
  private PromotionEditVo promotionEditVo;
}
