package com.biz.crm.nebular.dms.orderfeerate;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/1 11:36
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "计算订单现金费用限制返回信息的vo")
public class OrderFeeRateCalToCashResVo implements Serializable {

    /**
     * 本单计算基数
     */
    private BigDecimal calMoney;

    /**
     * 本单使用百分比（0<=this<=100）
     */
    private BigDecimal rate;

    /**
     * 本单最大使用额度
     */
    private BigDecimal maxMoney;

    public OrderFeeRateCalToCashResVo() {
    }

    public OrderFeeRateCalToCashResVo(BigDecimal calMoney, BigDecimal rate, BigDecimal maxMoney) {
        this.calMoney = calMoney;
        this.rate = rate;
        this.maxMoney = maxMoney;
    }
}
