package com.biz.crm.nebular.dms.promotion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Set;


/**
 * 促销政策查询VO
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策查询VO")
public class PromotionPolicyQueryVo extends PromotionPolicyVo {
    @ApiModelProperty(value = "有效期开始-起始")
    private String beginTime1;
    @ApiModelProperty(value = "有效期开始-结束")
    private String beginTime2;

    @ApiModelProperty(value = "有效期结束-起始")
    private String endTime1;
    @ApiModelProperty(value = "有效期结束-结束")
    private String endTime2;

    @ApiModelProperty(value = "促销政策编码集合")
    private Set<String> promotionCodes;

    @ApiModelProperty(value = "是否是查询有效的政策的标识,如果值为true,把无效的政策过滤掉,反之不做过滤")
    private Boolean queryEffectiveFlag=false;

    @ApiModelProperty(value = "活动申请结束时间")
    private String actEndDate;

    @ApiModelProperty(value = "是否需要分页查询")
    private Boolean needPageFlag=false;

    @ApiModelProperty(value = "是否查询范围数据")
    private Boolean queryScopeFlag=false;


}
