package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策")
public class PromotionPolicyVo extends CrmExtVo {

    /**
     * 促销编码
     */
    @ApiModelProperty(value = "促销编码")
    private String promotionPolicyCode;

    /**
     * 促销名称
     */
    @ApiModelProperty(value = "促销名称")
    private String promotionPolicyName;

    /**
     * 促销政策模板模板id
     */
    @ApiModelProperty(value = "促销政策模板模板id")
    private String templateId;

    /**
     * 促销政策模板模板code
     */
    @ApiModelProperty(value = "促销政策模板模板编码")
    private String templateCode;

    /**
     * 促销政策模板模板name
     */
    @ApiModelProperty(value = "促销政策模板模板名称")
    private String templateName;

    /**
     * 有效期开始
     */
    @ApiModelProperty(value = "有效期开始-时间")
    private String beginTime;


    /**
     * 有效期结束
     */
    @ApiModelProperty(value = "有效期结束-时间")
    private String endTime;


    /**
     * 政策叠加
     */
    @ApiModelProperty(value = "政策叠加")
    private String multipleable;

    @ApiModelProperty(value = "政策叠加字典翻译")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "multipleable")
    private String multipleableName;
    /**
     * 首单享受
     */
    @ApiModelProperty(value = "首单享受")
    private String firstOrder;

    @ApiModelProperty(value = "首单享受字典翻译")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "firstOrder")
    private String firstOrderName;
    /**
     * 促销描述
     */
    @ApiModelProperty(value = "促销描述")
    private String description;

    /**
     * 商品组合起订量
     */
    @ApiModelProperty(value = "商品组合起订量")
    private BigDecimal productsOrderQty;

    /**
     * 组合起订量类型
     */
    @ApiModelProperty(value = "组合起订量类型")
    private String productsOrderQtyType;

    @ApiModelProperty(value = "组合起订量类型字典翻译")
    @CrmDict(typeCode = "products_order_qty_type",dictCodeField = "productsOrderQtyType")
    private String productsOrderQtyTypeName;
    /**
     * 活动规划行号
     */
    @ApiModelProperty(value = "活动规划行号")
    private String actPlanNo;

    /**
     * 费率
     */
    @ApiModelProperty(value = "费率")
    private BigDecimal feeRate;
    /**
     * 渠道
     */
    @ApiModelProperty(value = "渠道")
    private String chanel;
    /**
     * 销售公司编码
     */
    @ApiModelProperty(value = "销售公司编码")
    private String saleCompanyCode;
    /**
     * 销售公司
     */
    @ApiModelProperty(value = "销售公司")
    private String saleCompanyName;

    /**
     * 政策使用量上限
     */
    @ApiModelProperty(value = "政策使用量上限")
    private BigDecimal usedQtyUpper;

    /**
     * 促销政策模板
     */
    private PromotionPolicyTemplateVo promotionPolicyTemplateVo;
    @ApiModelProperty(value = "审批状态")
    private String bpmStatus;

    @ApiModelProperty(value = "流程编号")
    private String crmProcessInstanceId;
    @ApiModelProperty(value = "流程提交时间")
    private String bpmSubmitDate;
    @ApiModelProperty(value = "流程通过时间")
    private String bpmPassDate;
    @ApiModelProperty(value = "提交人")
    private String bpmSubmitBy;
}
