package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.config.CrmDict;
import com.bizunited.platform.common.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * 促销规则
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销规则编辑页面vo")
public class PromotionRuleEditVo implements Serializable {
    @ApiModelProperty(value = "id")
    private String id;
    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码")
    private String ruleCode;

    /**
     * 规则类型 字典：promotion_policy_rule_type
     */
    @ApiModelProperty(value = "规则类型 字典：promotion_policy_rule_type")
    private String ruleType;
    @ApiModelProperty(value = "规则类型 字典：promotion_policy_rule_type")
    @CrmDict(typeCode = "promotion_policy_rule_type", dictCodeField = "ruleType")
    private String ruleTypeName;
    /**
     * 促销类型 字典：promotion_type
     */
    @ApiModelProperty(value = "促销类型 字典：promotion_type")
    private String promotionType;
    /**
     * 优先级-用于控制限量规则执行逻辑
     */
    @ApiModelProperty(value = "优先级-用于控制限量规则执行逻辑")
    private Integer levelNo;

    /**
     * 函数体
     */
    @ApiModelProperty(value = "函数实例名称")
    private String funcBody;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remarks;

    /**
     * 渲染参数
     */
    @ApiModelProperty(value = "规则参数对象")
    private TestParam testParam;


//    @ApiModelProperty(value = "调试参数Example")
//    private static final TestParam paramExample;

//    @ApiModelProperty(value = "函数体Example")
//    private static final String funcBodyExample = "def result = paramA * paramC; if('xiang'.equals(paramB)){ return result;} else {return result * 10;}";

//    public String getFuncBodyExample() {
//        return PromotionRuleEditVo.funcBodyExample;
//    }
//
//    public TestParam getParamExample() {
//        return PromotionRuleEditVo.paramExample;
//    }

//    static {
//        paramExample = new TestParam();
//        paramExample.setText("TestParam");
//
//        KeyValParamControl input = new KeyValParamControl();
//        input.setDescription("请输入paramA");
//        input.setControlType(KeyValParamControl.ControlType.input.name());
//        input.setKey("paramA");
//        input.setValue(10);
//        KeyValParamControl select = new KeyValParamControl();
//        select.setDescription("请选择paramB");
//        select.setControlType(KeyValParamControl.ControlType.select.name());
//        select.setKey("paramB");
//        select.setValue("xiang");
//        select.setSelectOptions(Lists.newArrayList(new SelectOption("xiang", "箱"), new SelectOption("ping", "瓶")));
//        KeyValParamControl def = new KeyValParamControl();
//        def.setKey("paramC");
//        def.setValue(55);
//        List<KeyValParamControl> controls = Lists.newArrayList(input, select, def);
//        paramExample.setControls(controls);
//    }
    public static void main(String[] args) {
        TestParam testParam = new TestParam();

        ControlRow paramExample = new ControlRow();
        paramExample.setText("本单中本品数量购买满");
        paramExample.setControlKey("control_key");
        KeyValParamControl input_base = new KeyValParamControl();
        input_base.setDescription("请输入本品数量");
        input_base.setControlType(KeyValParamControl.ControlType.input.name());
        input_base.setKey("buyNo");
        input_base.setValue(10);
        KeyValParamControl select = new KeyValParamControl();
        select.setDescription("请选择单位");
        select.setControlType(KeyValParamControl.ControlType.select.name());
        select.setKey("buyUnit");
        select.setValue("xiang");
        select.setSelectOptions(Lists.newArrayList(new SelectOption("xiang", "箱"), new SelectOption("ping", "瓶")));
        KeyValParamControl input_gift = new KeyValParamControl();
        input_gift.setDescription("请输入赠品数量");
        input_gift.setControlType(KeyValParamControl.ControlType.input.name());
        input_gift.setKey("giftNo");
        input_gift.setValue(55);
        List<KeyValParamControl> controls = Lists.newArrayList(input_base, select, input_gift, select);
        paramExample.setControls(controls);
        testParam.setControlRow(paramExample);
        Map<String, Object> map = Maps.newHashMap();
        map.put("productBuyNo", 10);
        testParam.setBizParam(map);
//        ControlRowParam controlRowParam = new ControlRowParam();
//        controlRowParam.setControlKey("control_key");
//        KeyValParam keyValParam1 = new KeyValParam();
//        keyValParam1.setKey("buyNo");
//        keyValParam1.setValue(1500);
//        KeyValParam keyValParam2 = new KeyValParam();
//        keyValParam2.setKey("giftNo");
//        keyValParam2.setValue(500);
//        controlRowParam.setControlKeyValParams(Lists.newArrayList(keyValParam1, keyValParam2));
//        testParam.setControlRowParam(controlRowParam);
        try {
            System.out.println(JsonUtils.obj2JsonString(testParam));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 调试参数
     *  @author: luoqi
     *  @Date: 2020-10-21 15:52
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class TestParam implements Serializable{
        /**
         * 业务参数
         */
        @ApiModelProperty(value = "额外的业务参数")
        private Map<String, Object> bizParam;
        /**
         * 规则函数参数控件列表
         */
        @ApiModelProperty(value = "控件行渲染参数")
        private ControlRow controlRow;
//        @ApiModelProperty(value = "控件行填入数据解析后的参数")
//        private ControlRowParam controlRowParam;
    }

    @Data
    public static class ControlRowParam implements Serializable{
        /**
         * 控件行编码
         */
        @ApiModelProperty(value = "控件行key")
        private String controlKey;
        /**
         * 控件行控件k-v列表
         */
        @ApiModelProperty(value = "控件行控件k-v列表")
        private List<KeyValParam> controlKeyValParams;
    }
    /**
     * 控件行
     *  @author: luoqi
     *  @Date: 2020-11-9 16:34
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class ControlRow implements Serializable{
        /**
         * 描述
         */
        @ApiModelProperty(value = "描述")
        private String text;
        /**
         * 控件行编码
         */
        @ApiModelProperty(value = "控件行key")
        private String controlKey;
        /**
         * {@link com.biz.crm.promotion.enums.ControlTypeDynamicEnum}
         */
        @ApiModelProperty(value = "控件行类型")
        private String controlType;
        /**
         * 规则函数参数控件列表
         */
        @ApiModelProperty(value = "规则函数参数控件列表")
        private List<KeyValParamControl> controls;
    }

    @Data
    public static class KeyValParam implements Serializable{
        public enum  ControlType{input, select}
        /**
         * 参数key
         */
        @ApiModelProperty(value = "参数key")
        private String key;
        /**
         * 参数值
         */
        @ApiModelProperty(value = "参数值")
        private Object value;
    }
    /**
     * 控件
     *  @author: luoqi
     *  @Date: 2020-10-21 15:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class KeyValParamControl extends KeyValParam implements Serializable{
        @ApiModelProperty(value = "控件label")
        private String label;
        @ApiModelProperty(value = "后缀")
        private String labelPostfix;
        /**
         * 控件描述
         */
        @ApiModelProperty(value = "控件描述")
        private String description;
        /**
         * 控件类型
         */
        @ApiModelProperty(value = "控件类型:input, select")
        private String controlType;
        /**
         * 下拉列表
         */
        @ApiModelProperty(value = "下拉列表")
        private List<SelectOption> selectOptions;
    }

    /**
     * 下拉对象
     *  @author: luoqi
     *  @Date: 2020-10-21 15:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @AllArgsConstructor
    public static class SelectOption implements Serializable{
        public SelectOption(){
        }
        @ApiModelProperty(value = "key")
        private String key;
        @ApiModelProperty(value = "value")
        private String value;
    }

}
